/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIClient;
import com.ibm.hwmca.fw.ui.UIException;
import com.ibm.hwmca.fw.ui.UIObjects;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TreePropertyListener;
import com.ibm.hwmca.ui.bonsai.servlet.BonsaiSettingsListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UISession {
    private static final String SESSION_KEY = "com.ibm.hwmca.ui.bonsai.UISession";
    private HMCSession hmcSession;
    private Set userRoles;
    private UIObjects uiObjects;
    private boolean activeSelectionTree;
    private List treeSelectionPath;
    private List tableSelection;
    private List taskNodes;
    private static final String TRACEMASK_T = "XBUISEST";
    private static final String TRACEMASK_F = "XBUISESF";
    private static final String TRACEMASK_D = "XBUISESD";

    public void init(HMCSession hmcSession) throws TaskletException, UIException, HException {
        Trace.trace(TRACEMASK_F, "--> UISession.init(" + hmcSession + ")");
        if (hmcSession == null) {
            throw new IllegalStateException("HMCSession has not yet been set!");
        }
        hmcSession.setSessionAttribute(SESSION_KEY, this);
        this.hmcSession = hmcSession;
        this.uiObjects = new UIObjects(hmcSession);
        UIClient client = this.uiObjects.getUIClient();
        client.addUserSettingsListener(new BonsaiSettingsListener(this));
        client.addUIClientListener(new TreePropertyListener(this));
        this.userRoles = User.getUser(hmcSession.getUserContext().getUserName()).getUserRoles();
        Trace.trace(TRACEMASK_F, "<-- UISession.init()");
    }

    public HMCSession getHMCSession() {
        return this.hmcSession;
    }

    public Locale getLocale() {
        return this.hmcSession.getUserContext().getLocale();
    }

    public UIClient getUIClient() {
        return this.uiObjects.getUIClient();
    }

    public UIObjectsReader getUIObjectsReader() {
        return this.uiObjects.getUIObjectsReader();
    }

    public Set getUserRoles() {
        return this.userRoles;
    }

    public boolean isActiveSelectionTree() {
        return this.activeSelectionTree;
    }

    public void setActiveSelectionTree(boolean activeSelectionTree) {
        this.activeSelectionTree = activeSelectionTree;
    }

    public String getTreeSelection() {
        if (this.treeSelectionPath.isEmpty()) {
            return null;
        }
        BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
        String id = null;
        Iterator i = this.treeSelectionPath.iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            if (treeManager.getTreeNode(id) == null) continue;
            return id;
        }
        return null;
    }

    public void setTreeSelection(String treeSelection) {
        BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
        this.treeSelectionPath = new ArrayList();
        for (BonsaiTreeNode node = treeManager.getTreeNode(treeSelection); node != null; node = node.getParent()) {
            this.treeSelectionPath.add(node.getId());
        }
    }

    public List getTableSelection() {
        return this.tableSelection;
    }

    public void setTableSelection(List tableSelection) {
        this.tableSelection = tableSelection;
    }

    public List getResourceTaskTrees() {
        return this.taskNodes;
    }

    public void setResourceTaskTrees(List taskNodes) {
        this.taskNodes = taskNodes;
    }

    public static synchronized UISession getUISession(HMCSession hmcSession) {
        return (UISession)hmcSession.getSessionAttribute(SESSION_KEY);
    }
}

